/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.NetherKnightConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;

public class NetherKnightEntity
extends Monster
implements ILexiconEntry {
    public NetherKnightEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, NetherKnightConfig.health()).m_22268_(Attributes.f_22279_, NetherKnightConfig.movementSpeed()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, NetherKnightConfig.attackDamage());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, SpawnGroupData data, CompoundTag nbt) {
        this.m_21553_(false);
        this.m_21559_(world.m_213780_().m_188499_());
        this.m_213945_(this.f_19796_, difficultyInstance);
        return super.m_6518_(world, difficultyInstance, spawnReason, data, nbt);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance $$1) {
        EquipmentSlot first = random.m_188499_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        EquipmentSlot second = first == EquipmentSlot.MAINHAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
        this.m_8061_(first, this.createMainHandItem(random));
        this.m_8061_(second, this.createOffHandItem(random));
    }

    protected void m_5907_() {
        ItemStack offHand;
        double dropChance = NetherKnightConfig.weaponDropChance() / 100.0;
        ItemStack mainHand = this.m_21205_();
        if (mainHand != null && this.f_19796_.m_188500_() < dropChance) {
            mainHand.m_41721_(500 + this.f_19796_.m_188503_(500));
            this.m_19983_(mainHand);
        }
        if ((offHand = this.m_21206_()) != null && this.f_19796_.m_188500_() < dropChance) {
            offHand.m_41721_(500 + this.f_19796_.m_188503_(500));
            this.m_19983_(offHand);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.2, false, NetherKnightConfig::canAttack));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{NetherKnightEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    private ItemStack createMainHandItem(RandomSource random) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42393_);
        ImmutableList<String> names = NetherKnightConfig.get().swordNames.get();
        String name = (String)names.get(random.m_188503_(names.size()));
        if (random.m_188503_(1000) == 0) {
            name = "Buecher_wurm's Butter Knife";
            stack.m_41663_(Enchantments.f_44977_, 4 + random.m_188503_(6));
            stack.m_41663_(Enchantments.f_44981_, 1 + random.m_188503_(2));
            stack.m_41663_(Enchantments.f_44980_, 1 + random.m_188503_(2));
            stack.m_41663_(Enchantments.f_44986_, 1 + random.m_188503_(3));
        } else {
            stack.m_41663_(Enchantments.f_44977_, 2 + random.m_188503_(3));
        }
        stack.m_41663_(Enchantments.f_44982_, 1);
        stack.m_41714_((Component)Component.m_237113_((String)name));
        return stack;
    }

    private ItemStack createOffHandItem(RandomSource random) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42396_);
        ImmutableList<String> names = NetherKnightConfig.get().axeNames.get();
        String name = (String)names.get(random.m_188503_(names.size()));
        if (random.m_188503_(1000) == 0) {
            name = "Buecher_wurm's War Axe";
            stack.m_41663_(Enchantments.f_44962_, 1);
            stack.m_41663_(Enchantments.f_44984_, 3 + random.m_188503_(3));
        } else {
            stack.m_41663_(Enchantments.f_44984_, 1 + random.m_188503_(3));
        }
        stack.m_41663_(Enchantments.f_44977_, 2);
        stack.m_41714_((Component)Component.m_237113_((String)name));
        return stack;
    }

    protected SoundEvent m_7515_() {
        return ModSounds.NETHER_KNIGHT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.NETHER_KNIGHT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.NETHER_KNIGHT_DEATH.get();
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(ModSounds.NETHER_KNIGHT_STEP.get(), 0.15f, 1.0f);
    }

    public boolean m_6126_() {
        return false;
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13132_);
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_()) {
            CollisionContext iselectioncontext = CollisionContext.m_82750_((Entity)this);
            if (iselectioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    protected void m_7840_(double p_184231_1_, boolean p_184231_3_, BlockState state, BlockPos pos) {
        if (this.m_20077_()) {
            this.f_19789_ = 0.0f;
        } else {
            super.m_7840_(p_184231_1_, p_184231_3_, state, pos);
        }
    }

    public boolean m_7327_(Entity entity) {
        if (!super.m_7327_(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100));
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return super.m_6469_(source, damage);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19615_ ? false : super.m_7301_(effect);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.NETHER_KNIGHT;
    }
}

